function retstr = MWS_1rad_udaje(instruct)
retstr = char('');
conf2

yx = str2num(instruct.yx);
y0 = str2num(instruct.y0);
Tu = str2num(instruct.Tu);
Tn = str2num(instruct.Tn);
ux = str2num(instruct.ux);
u0 = str2num(instruct.u0);

k = [0.99 0.95 0.9 0.8 0.4 0.2 0.1 0.05]';
f2k = [2.705 2.650 2.581 2.441 1.842 1.495 1.292 1.171]';
f1k = [9.649 9.653 9.665 9.72 10.91 13.974 20.088 31.737]';

K = ( yx - y0 ) / ( ux -u0 );
f1kv = Tn / Tu;

indx = find(f1kv<f1k);
f2k = f2k(indx(1));
k = k(indx(1));

T1 = Tn / f2k;
T2 = k * T1;
T12n = T1 * T2;
T12s = T1 + T2;
D = 0;

open_system('schema2');
set_param('schema2/Funkcia','Numerator',num2str(K));
set_param('schema2/Skok','Before',instruct.u0);
set_param('schema2/Skok','After',instruct.ux);
set_param('schema2/Transport','DelayTime',num2str(D));
set_param('schema2/Funkcia','Denominator',sprintf('[%d %d 1]',T12n,T12s));
StopTime = Tn * 2.5;
sim('schema2',StopTime);

wscleanup('ml*.jpg',1);

fout = figure('visible','off');
plot(tout,yout,'r');
xlabel('t (s)');
ylabel('y');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.K = K;
outstruct.T1 = T1;
outstruct.T2 = T2;
outstruct.suma_s = 'Is not possible to define.';
outstruct.graf = jpgname;

templatefile = which('zaver_2rad.html');
retstr = htmlrep(outstruct, templatefile);