function retstr = MWS_2rad_nacitanie(instruct)
retstr = char('');
%instruct
conf1

eval(sprintf('load %s;',instruct.subor));
eval(sprintf('mat = X%s;',instruct.subor));

t = mat(:,1);
u = mat(:,2);
y = mat(:,3);
ux = max(u);
u0 = min(u);
if u0 == ux
   u0 = 0;
end;

d1y = y(2:end) - y(1:end-1);
indx = find(d1y<0);
t1 = t(indx(1));
y1 = y(indx(1));

kon = max(indx);
zac = indx;
submat = mat(zac:kon,1:3);
ysm = submat(:,3);
tsm = submat(:,1);
d1ysm = ysm(2:end) - ysm(1:end-1);
indx = find(d1ysm>0);
y2 = ysm(indx(1));
t2 = tsm(indx(1));

M = ( y1 - y2 ) / y1;
m = sqrt( 3.14^2 + ( log( M ) )^2 );
r = abs( log( M ) / m );
P = sqrt( 1 - r^2 );
om = 3.14 / ( ( t2 - t1 ) * P );
T = 1 / om;
K = y1 / ( 1 + M );
D = 0;

a = T^2;
b = 2 * T * r;

conf2

StopTime = max(t);

x = K * M / P + om;
mat = mat';
save(sprintf('data_%d.mat',x),'mat');

open_system('schema');
set_param('schema/FromFile','FileName',sprintf('data_%d.mat',x));
set_param('schema/Funkcia','Numerator',num2str(K));
set_param('schema/Transport','DelayTime',num2str(D));
set_param('schema/Funkcia','Denominator',sprintf('[%d %d 1]',a,b));
sim('schema',StopTime);

rozdiel = yout - ynac;
suma_stvorcov = rozdiel'*rozdiel;

wscleanup('data_*.mat',1);
wscleanup('ml*.jpg',1);

fout = figure('visible','off');
plot(tout,yout,'r',tout,ynac,'b');
legend('PCH identifikovaneho systemu','PCH neznameho systemu');
xlabel('t (s)');
ylabel('y');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);

close('all');

outstruct.graf = jpgname;
outstruct.suma_s = suma_stvorcov;
outstruct.K = K;
outstruct.T = T;
outstruct.r = r;
outstruct.a = a;
outstruct.b = b;

templatefile = which('zaver_kmitanie.html');
retstr = htmlrep(outstruct, templatefile);