function retstr = MWS_nrad_broid_udaje(instruct)
retstr = char('');
%instruct
conf2

yx = str2num(instruct.yx);
y0 = str2num(instruct.y0);
Tu = str2num(instruct.Tu);
Tn = str2num(instruct.Tn);
ux = str2num(instruct.ux);
u0 = str2num(instruct.u0);

n = [6 5 4 3 2 1]';
fn = [0.385 0.331 0.268 0.192 0.096 0.000]';
gn = [0.400 0.410 0.420 0.440 0.500 1.000]';

f = round(1000 * Tu / Tn)/1000;
K = ( yx - y0 ) / ( ux - u0 );
index_f = find(fn<f);
fn = fn(index_f(1));
gn = gn(index_f(1));
n = n(index_f(1));
D = ( f - fn ) * Tn;
T = Tn * gn;

a = [T 1];
b = [T/2 1];
c = [T/3 1];
d = [T/4 1];
e = [T/5 1];
f = [T/6 1];

g = conv(a,b);
h = conv(g,c);
k = conv(h,d);
l = conv(k,e);
m = conv(l,f);

if n==1
    Menovatel = a;
elseif n==2
    Menovatel = g;
elseif n==3
    Menovatel = h;
elseif n==4
    Menovatel = k;
elseif n==5
    Menovatel = l;
else
    Menovatel = m;
end;

open_system('schema2');
set_param('schema2/Funkcia','Numerator',num2str(K));
set_param('schema2/Skok','Before',num2str(u0));
set_param('schema2/Skok','After',num2str(ux));
set_param('schema2/Transport','DelayTime',num2str(D));
set_param('schema2/Funkcia','Denominator',sprintf('[%s]',num2str(Menovatel)));
StopTime = Tn * 2.5;
sim('schema2',StopTime);

wscleanup('ml*.jpg',1);

fout = figure('visible','off');
plot(tout,yout,'r');
xlabel('t (s)');
ylabel('y'); 
%text(bod_t2,bod_y2,'\leftarrow inflexny bod');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.T = T;
outstruct.D = D;
outstruct.K = K;
outstruct.n = n;
outstruct.Menovatel = Menovatel;
outstruct.suma_s = 'Is not possible to define.';
outstruct.graf = jpgname;

if n==1
    templatefile = which('zaver_broid1.html');
elseif n==2
    a = 1.5 * T;
    b = 0.5 * T^2;
    templatefile = which('zaver_broid2.html');
elseif n==3
    a = 1.8333 * T;
    b = T^2;
    c = 0.1667 * T^3;
    templatefile = which('zaver_broid3.html');
elseif n==4
    a = 2.0833 * T;
    b = 1.4583 * T^2;
    c = 0.1467 * T^3;
    d = 0.0417 * T^4;
    templatefile = which('zaver_broid4.html');
elseif n==5
    a = 2.2833 * T;
    b = 1.875 * T^2;
    c = 0.7083 * T^3;
    d = 0.125 * T^4;
    e = 0.0083 * T^5;
    templatefile = which('zaver_broid5.html');
else
    a = 2.45 * T;
    b = 2.2556 * T^2;
    c = 1.0208 * T^3;
    d = 0.2431 * T^4;
    e = 0.0292 * T^5;
    f = 0.0014 * T^6;
    templatefile = which('zaver_broid6.html');
end;

outstruct.a = a;
outstruct.b = b;
outstruct.c = c;
outstruct.d = d;
outstruct.e = e;
outstruct.f = f;

retstr = htmlrep(outstruct, templatefile);