function retstr = MWS_nrad_strejc(instruct)
retstr = char('');
%instruct
conf1

eval(sprintf('load %s;',instruct.subor));
eval(sprintf('mat = X%s;',instruct.subor));

t = mat(:,1);
u = mat(:,2);
y = mat(:,3);
ux = max(u);
u0 = min(u);
if u0 == ux
   u0 = 0;
end;
y0 = min(y);
yx = max(y);

d1y = y(2:end) - y(1:end-1);
d1t = t(2:end) - t(1:end-1);
delmat = d1y./d1t;
max_dm = max(delmat);
indx = find(max_dm==delmat);

bod_t1 = t(indx+1);
bod_y1 = y(indx+1);
bod_t2 = t(indx);
bod_y2 = y(indx);

a = (bod_y2 - bod_y1) / (bod_t2 - bod_t1);
b = bod_y2 - a*bod_t2;
Tu = ( y0 - b ) / a;
Tn = ( yx - b ) / a - Tu;

n = [6 5 4 3 2 1]';
fn = [0.493 0.410 0.319 0.218 0.104 0.000]';
gn = [0.161 0.195 0.224 0.271 0.368 1.000]';
%stupen = [n fn gn];

f = round(1000 * Tu / Tn)/1000;
K = ( yx - y0 ) / ( ux - u0 );
index_f = find(fn<f);
fn = fn(index_f(1));
gn = gn(index_f(1));
n = n(index_f(1));
D = ( f - fn ) * Tn;
T = Tn * gn;

a = [T 1];
b = conv(a,a);
c = conv(b,b);

if n == 1
    Menovatel = a;
elseif n == 2
    Menovatel = b;
elseif n == 3
    Menovatel = conv(a,b);
elseif n == 4
    Menovatel = conv(b,b);
elseif n == 5
    Menovatel = conv(c,a);
else
    Menovatel = conv(c,b);
end;

conf2

StopTime = max(t);

x = K * T + D;
mat = mat';
save(sprintf('data_%d.mat',x),'mat');

open_system('schema');
set_param('schema/FromFile','FileName',sprintf('data_%d.mat',x));
set_param('schema/Funkcia','Numerator',num2str(K));
set_param('schema/Transport','DelayTime',num2str(D));
set_param('schema/Funkcia','Denominator',sprintf('[%s]',num2str(Menovatel)));
sim('schema',StopTime);

rozdiel = yout - ynac;
suma_stvorcov = rozdiel'*rozdiel;

wscleanup('ml*.jpg',1);
wscleanup('data_*.mat',1);

fout = figure('visible','off');
plot(tout,yout,'r',tout,ynac,'b');
legend('PCH identifikovaneho systemu','PCH neznameho systemu');
xlabel('t (s)');
ylabel('y'); 
text(bod_t2,bod_y2,'\leftarrow inflexny bod');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);

close('all');

outstruct.graf = jpgname;
outstruct.T = T;
outstruct.D = D;
outstruct.K = K;
outstruct.n = n;
outstruct.Menovatel = Menovatel;
outstruct.suma_s = suma_stvorcov;

templatefile = which('zaver_strejc.html');
retstr = htmlrep(outstruct, templatefile);