function retstr = MWS_nrad_strejc_udaje(instruct)
retstr = char('');
%instruct
conf2

yx = str2num(instruct.yx);
y0 = str2num(instruct.y0);
Tu = str2num(instruct.Tu);
Tn = str2num(instruct.Tn);
ux = str2num(instruct.ux);
u0 = str2num(instruct.u0);

n = [6 5 4 3 2 1]';
fn = [0.493 0.410 0.319 0.218 0.104 0.000]';
gn = [0.161 0.195 0.224 0.271 0.368 1.000]';
%stupen = [n fn gn];

f = round(1000 * Tu / Tn)/1000;
K = ( yx - y0 ) / ( ux - u0 );
index_f = find(fn<f);
fn = fn(index_f(1));
gn = gn(index_f(1));
n = n(index_f(1));
D = ( f - fn ) * Tn;
T = Tn * gn;

a = [T 1];
b = conv(a,a);
c = conv(b,b);

if n == 2
    Menovatel = b;
elseif n == 3
    Menovatel = conv(a,b);
elseif n == 4
    Menovatel = conv(b,b);
elseif n == 5
    Menovatel = conv(c,a);
else
    Menovatel = conv(c,b);
end;
open_system('schema2');
set_param('schema2/Skok','Before',instruct.u0);
set_param('schema2/Skok','After',instruct.ux);
set_param('schema2/Transport','DelayTime',num2str(D));
set_param('schema2/Funkcia','Denominator',sprintf('[%s]',num2str(Menovatel)));
set_param('schema2/Funkcia','Numerator',num2str(K));
StopTime = Tn * 2.5;
sim('schema2',StopTime);

wscleanup('ml*.jpg',1);

fout = figure('visible','off');
plot(tout,yout,'r');
xlabel('t (s)');
ylabel('y'); 
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.graf = jpgname;
outstruct.T = T;
outstruct.D = D;
outstruct.K = K;
outstruct.n = n;
outstruct.suma_s = 'Is not possible to define.';

templatefile = which('zaver_strejc.html');
retstr = htmlrep(outstruct, templatefile);