function retstr = MWS_1rad_nacitanie(instruct)
retstr = char('');
%instruct
conf1

eval(sprintf('load %s;',instruct.subor));
eval(sprintf('mat = X%s;',instruct.subor));

t = mat(:,1);
u = mat(:,2);
y = mat(:,3);
ux = max(u);
u0 = min(u);
if u0 == ux
   u0 = 0;
end;
yx = max(y);
y0 = min(y);

y1h = 0.2 * yx;
y2h = 0.8 * yx;
%20percenten
for yh = 1:length(y),
    if y(yh) < y1h
       y1 = y(yh);
       t1 = t(yh);
   end;
end;
%80percent
for yhh = 1:length(y),
    if y(yhh) < y2h
       y2 = y(yhh);
       t2 = t(yhh);
   end;
end;

K = (yx - y0) / (ux - u0);
T = ( t2 - t1 ) / log( ( K - y1 ) / ( K - y2) );
x = ( log( (K - y1)/K ) / log(( K - y2)/K ) );
D = ( t2 * x - t1 ) / ( x - 1 );

if D < 0
    D = 0;
end;

conf2

StopTime = max(t);

x = K / T + D;
mat = mat';
save(sprintf('data_%d.mat',x),'mat');

open_system('schema');
set_param('schema/FromFile','FileName',sprintf('data_%d.mat',x));
set_param('schema/Funkcia','Numerator',num2str(K));
set_param('schema/Transport','DelayTime',num2str(D));
set_param('schema/Funkcia','Denominator',sprintf('[%d 1]',T));
sim('schema',StopTime);

rozdiel = yout - ynac;
suma_stvorcov = rozdiel'*rozdiel;

wscleanup('ml*.jpg',1);
wscleanup('data_*.mat',1);

fout = figure('visible','off');
plot(tout,yout,'r',tout,ynac,'b');
legend('PCH identifikovaneho systemu','PCH neznameho systemu');
xlabel('t (s)');
ylabel('y');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.K = K;
outstruct.T = T;
outstruct.D = D;
outstruct.graf = jpgname;
outstruct.suma_s = suma_stvorcov;

templatefile = which('zaver_1rad.html');
retstr = htmlrep(outstruct, templatefile);