function retstr = MWS_1rad_udaje(instruct)
retstr = char('');
conf2
%instruct

yx = str2num(instruct.yx);
y0 = str2num(instruct.y0);
ux = str2num(instruct.ux);
u0 = str2num(instruct.u0);
y1 = str2num(instruct.y1);
y2 = str2num(instruct.y2);
t1 = str2num(instruct.t1);
t2 = str2num(instruct.t2);
    
K = (yx - y0) / (ux - u0);
T = ( t2 - t1 ) / log( ( K - y1 ) / ( K - y2) );
x = ( log( ( K - y1 ) / K ) / log( ( K - y2 ) / K ) );
D = ( t2 * x - t1 ) / ( x - 1 );
if D < 0
    D = 0;
end;

open_system('schema2');
set_param('schema2/Funkcia','Numerator',num2str(K));
set_param('schema2/Skok','Before',instruct.u0);
set_param('schema2/Skok','After',instruct.ux);
set_param('schema2/Transport','DelayTime',num2str(D));
set_param('schema2/Funkcia','Denominator',sprintf('[%d 1]',T));
StopTime = t2/0.7 + 3 + D;
sim('schema2',StopTime);

wscleanup('ml*.jpg',1);

fout = figure('visible','off');
plot(tout,yout,'r');
xlabel('t (s)');
ylabel('y');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.K = K;
outstruct.T = T;
outstruct.D = D;
outstruct.suma_s = 'Is not possible to define.';
outstruct.graf = jpgname;

%outstruct
templatefile = which('zaver_1rad.html');
retstr = htmlrep(outstruct, templatefile);