function retstr = MWS_2rad_nacitanie(instruct)
retstr = char('');
%instruct
conf1

eval(sprintf('load %s;',instruct.subor));
eval(sprintf('mat = X%s;',instruct.subor));

t = mat(:,1);
u = mat(:,2);
y = mat(:,3);
ux = max(u);
u0 = min(u);
if u0 == ux
   u0 = 0;
end;
y0 = min(y);
yx = max(y);
K = ( yx - y0 ) / ( ux - u0 );

d1y = y(2:end) - y(1:end-1);
d1t = t(2:end) - t(1:end-1);
delmat = d1y./d1t;
max_dm = max(delmat);
indx = find(max_dm==delmat);

bod_t1 = t(indx+1);
bod_y1 = y(indx+1);
bod_t2 = t(indx);
bod_y2 = y(indx);

a = (bod_y2 - bod_y1) / (bod_t2 - bod_t1);
b = bod_y2 - a*bod_t2;
Tu = ( y0 - b ) / a;
Tn = ( yx - b ) / a - Tu;
f1kv = Tn / Tu;

k = [0.99 0.95 0.9 0.8 0.4 0.2 0.1 0.05]';
f2k = [2.705 2.650 2.581 2.441 1.842 1.495 1.292 1.171]';
f1k = [9.649 9.653 9.665 9.72 10.91 13.974 20.088 31.737]';
indx = find(f1kv<f1k);
f2k = f2k(indx(1));
k = k(indx(1));

T1 = Tn / f2k;
T2 = k * T1;
T12n = T1 * T2;
T12s = T1 + T2;
D = 0;

conf2

StopTime = max(t);

x = T12n / T12s + b * a;
mat = mat';
save(sprintf('data_%d.mat',x),'mat');

open_system('schema');
set_param('schema/FromFile','FileName',sprintf('data_%d.mat',x));
set_param('schema/Funkcia','Numerator',num2str(K));
set_param('schema/Transport','DelayTime',num2str(D));
set_param('schema/Funkcia','Denominator',sprintf('[%d %d 1]',T12n,T12s));
sim('schema',StopTime);

rozdiel = yout - ynac;
suma_stvorcov = rozdiel'*rozdiel;

wscleanup('ml*.jpg',1);
wscleanup('data_*.mat',1);

fout = figure('visible','off');
plot(tout,yout,'r',tout,ynac,'b');
legend('PCH identifikovaneho systemu','PCH neznameho systemu');
xlabel('t (s)');
ylabel('y'); 
text(bod_t1,bod_y1,'\leftarrow inflexny bod');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.suma_s = suma_stvorcov;
outstruct.graf = jpgname;
outstruct.K = K;
outstruct.T1 = T1;
outstruct.T2 = T2;

templatefile = which('zaver_2rad.html');
retstr = htmlrep(outstruct, templatefile);