function retstr = MWS_1rad_udaje(instruct)
retstr = char('');
conf2

y1 = str2num(instruct.y1);
y2 = str2num(instruct.y2);
t1 = str2num(instruct.t1);
t2 = str2num(instruct.t2);

M = ( y1 - y2 ) / y1;
m = sqrt( 3.14^2 + ( log( M ) )^2 );
r = abs( log( M ) / m );
P = sqrt( 1 - r^2 );
om = 3.14 / ( ( t2 - t1 ) * P );
T = 1 / om;
K = y1 / ( 1 + M );
D = 0;

a = T^2;
b = 2 * T * r;

open_system('schema2');
set_param('schema2/Funkcia','Numerator',num2str(K));
set_param('schema2/Skok','Before',instruct.u0);
set_param('schema2/Skok','After',instruct.ux);
set_param('schema2/Transport','DelayTime',num2str(D));
set_param('schema2/Funkcia','Denominator',sprintf('[%d %d 1]',a,b));
StopTime = t2 * 5;
sim('schema2',StopTime);

wscleanup('ml*.jpg',1);

fout = figure('visible','off');
plot(tout,yout,'r');
xlabel('t (s)');
ylabel('y');
jpgname = sprintf('%s.jpg',instruct.mlid);
drawnow;
wsprintjpeg(fout,jpgname);
close('all');

outstruct.graf = jpgname;
outstruct.K = K;
outstruct.T = T;
outstruct.r = r;
outstruct.a = a;
outstruct.b = b;
outstruct.suma_s = 'Is not possible to define.';

templatefile = which('zaver_kmitanie.html');
retstr = htmlrep(outstruct, templatefile);