function testinputvar(optim_param)


% optvar must be a number from 1 to 7
% 1- t | 2- u | 3- t,u | 4- p | 5- t,p | 6- u,p | 7- t,u,p
%..................................................................
if ((isempty(optim_param.optvar) || ~isnumeric(optim_param.optvar)) ...
        || (optim_param.optvar > 7))
    errmsg = sprintf('%s\n%s %s %s', ...
        'Incorrect use of function dynopt:', ...
        'Parameter OPTVAR in optim_param structure', ... 
        'must be a number within 1 and 7.'); 
    error(errmsg);
end
%..................................................................

% objtype must be an empty matrix [], or structure containing two
% variables, tm and xm objtype.tm and objtype.xm 
% tm- [m-by-1] vector | xm- [nx-by-m] matrix
%..................................................................
if ~isempty(optim_param.objtype)
    if ~isstruct(optim_param.objtype)
        errmsg = sprintf('%s\n%s %s', ...
            'Incorrect use of function dynopt:', ...
            'Parameter OBJTYPE must be an empty matrix or structure', ...
            'holding variables TM and XM.');    
        error(errmsg);
    else
        if (~isfield(optim_param.objtype,'tm') || ...
                ~isfield(optim_param.objtype,'xm'))
            errmsg = sprintf('%s\n%s %s', ...
                'Incorrect use of function dynopt:', ...
                'Parameter OBJTYPE must be a structure', ...
                'holding parameters TM and XM.'); 
            error(errmsg);
        elseif (length(optim_param.objtype.tm) ~= ...
                size(optim_param.objtype.xm,2))
            errmsg = sprintf('%s\n%s %s', ...
                'Incorrect use of function dynopt:', ...
                'Parameters TM and XM in OBJTYPE parameter', ...
                'are not regular defined.');
            error(errmsg);
        end
    end
end
%..................................................................

% ncolx must be a number greater than 0
%..................................................................
if (~isnumeric(optim_param.ncolx) || isempty(optim_param.ncolx) ...
        || optim_param.ncolx == 0)
    errmsg = sprintf('%s\n %s', 'Incorrect use of function dynopt:', ...
        'Parameter NCOLX must be a number greater then 0.');
    error(errmsg);
end
%..................................................................

% ncolu can be either an empty matrix or a number greater than 0
%..................................................................
if (~isnumeric(optim_param.ncolu) || (~isempty(optim_param.ncolu) ...
        && optim_param.ncolu == 0))
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter NCOLU must be an empty matrix', ...
        'or a number greater then 0.');
    error(errmsg);
end
%..................................................................

% li_init must be a column vector of length of number of intervals
%..................................................................
if (~isnumeric(optim_param.li) || isempty(optim_param.li) ...
        || size(optim_param.li,2) > 1)
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter LI must be a column vector', ...
        'of length of number of intervals.');
    error(errmsg);
end
%..................................................................

% if tf isn't empty matrix t must belong to optimised parameters and tf
% must be greater than 0
%..................................................................
if ~isnumeric(optim_param.tf)
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter TF must be either an empty matrix', ...
        'or a number greater than 0.');
    error(errmsg);
elseif ~isempty(optim_param.tf)
    if (optim_param.optvar == 2 || optim_param.optvar == 4 ...
            || optim_param.optvar == 6)
        errmsg = sprintf('%s\n%s\n%s', ...
            'Incorrect use of function dynopt:', ...
            'Parameter TF must be an empty matrix.', ...
            'See also parameter OPTVAR.');
        error(errmsg);
    elseif (optim_param.tf == 0)
        errmsg = sprintf('%s\n%s','Incorrect use of function dynopt:', ...
            'Parameter TF must be greater than 0.');
        error(errmsg);
    end
end
%..................................................................

% if u is not optimised variable: u_init can be an empty matrix or nu-by-ni
% matrix, if u belongs to the optimised variables: u_init has always to be
% an nu-by-ni matrix
%..................................................................
if ~isnumeric(optim_param.ui) 
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter UI must be an empty matrix', ...
        'or a numeric array.');
    error(errmsg);
end
if ~isempty(optim_param.ui)
    if (size(optim_param.ui,2) ~= length(optim_param.li))
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter UI must have the same number', ...
            'of columns as is the number of intervals.');
        error(errmsg);
    end
else
    if (optim_param.optvar == 2 || optim_param.optvar == 3 ...
            || optim_param.optvar ==  6 || optim_param.optvar ==  7) 
        errmsg = sprintf('%s\n%s','Incorrect use of function dynopt:', ...
            'Parameter UI must be a numeric array.');
        error(errmsg);
    end
end
%..................................................................

% if p is not optimised variable: par_init can be an empty matrix or
% np-by-1 matrix, if p belongs to the optimised variables: par_init has
% always to be an np-by-1 vector
%..................................................................
if ~isnumeric(optim_param.par) 
    errmsg = sprintf('%s\n%s','Incorrect use of function dynopt:', ...
        'Parameter PAR must be a numeric array.');
    error(errmsg);
end
if ~isempty(optim_param.par)
    if(size(optim_param.par,2) > 1)
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter PAR must be an np-by-1 vector, ', ...
            'where np is number of parameters.');
        error(errmsg);
    end
else
    if (optim_param.optvar == 4 || optim_param.optvar == 5 ...
            || optim_param.optvar == 6 || optim_param.optvar == 7)
        errmsg = sprintf('%s\n%s %s\n%s', ...
            'Incorrect use of function dynopt:', ...
            'Parameter PAR must be np-by-1 numeric array,', ...
            'where np is number of parameters.', ...
            'See also parameter OPTVAR.');
        error(errmsg);
    end
end
%..................................................................

% if u is not optimised variable: bdu must be always empty matrix, if u
% belongs to optimised variables: bdu can either be an empty matrix or has
% to be nu-by-2 matrix
%..................................................................
if ~isnumeric(optim_param.bdu) 
    errmsg = sprintf('%s\n%s %s %s','Incorrect use of function dynopt:', ...
        'Parameter BDU must be an empty matrix', ...
        'or an nu-by-2 numeric matrix, where nu is number of control', ...
        'variables.');
    error(errmsg);
end
if ~isempty(optim_param.bdu)
    if (optim_param.optvar == 1 || optim_param.optvar == 4 ...
            || optim_param.optvar == 5)
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter BDU must be an empty matrix,', ...
            'or parameter OPTVAR must be either 2 or 3 or 6 or 7.');
        error(errmsg);
    elseif ((size(optim_param.bdu,1) ~= size(optim_param.ui,1)) ...
            || size(optim_param.bdu,2) ~= 2)
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter BDU must be an nu-by-2 numeric matrix,', ...
            'where nu is number of control variables, see also parameter UI.');
        error(errmsg);
    end   
end
%..................................................................

% if p is not optimised variable: bdp must be always empty matrix, if p
% belongs to optimised variables: bdp can either be an empty matrix or has
% to be np-by-2 matrix
%..................................................................
if ~isnumeric(optim_param.bdp) 
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter BDP must be an empty matrix or an np-by-2', ...
        'numeric matrix, where np is number of parameters.');
    error(errmsg);
end
if ~isempty(optim_param.bdp)
    if (optim_param.optvar == 1 || optim_param.optvar == 2 ...
            || optim_param.optvar == 3)
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter BDP must be an empty matrix,', ...
            'or parameter OPTVAR must be either 4 or 5 or 6 or 7.');
        error(errmsg);
    elseif ((size(optim_param.bdp,1) ~= size(optim_param.par,1)) ...
            || size(optim_param.bdp,2) ~= 2)
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter BDP must be an np-by-2 numeric matrix,', ...
            'where np is number of parameters, see also parameter PAR.');
        error(errmsg);
    end
end
%..................................................................

% objfun has always to be defined as @function_name
%..................................................................
if (isempty(optim_param.objfun) || ~isa(optim_param.objfun,'function_handle'))
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter OBJFUN must be defined as @function_name.');
    error(errmsg);
end
%..................................................................

% if parameter const is an empty matrix confun has also to be an empty
% matrix, if parameter const is defined also confun has to be defined as
% @function_name
%..................................................................
if (~isempty(optim_param.confun) && ~isa(optim_param.confun,'function_handle'))
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter CONFUN must be defined as @function_name.');
    error(errmsg);
end
%..................................................................

% process has always to be defined as @function_name
%..................................................................
if (isempty(optim_param.process) || ~isa(optim_param.process,'function_handle'))
    errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
        'Parameter PROCESS must be defined as @function_name');
    error(errmsg);
end
%..................................................................

% x is always optimised, bdx can be defined or it doesn't have to be
% defined but if it is defined it has to be an nx-by-2 matrix
%..................................................................
if ~isnumeric(optim_param.bdx) 
    errmsg = sprintf('%s\n%s %s %s','Incorrect use of function dynopt:', ...
        'Parameter BDX must be an empty matrix', ...
        'or an nx-by-2 numeric matrix, where nx is number of state', ...
        'variables.');
    error(errmsg);
end
if ~isempty(optim_param.bdx)
    if ((size(optim_param.bdx,1) ~= ...
            length(feval(optim_param.process,0,0,5,0,optim_param.par))) ...
            || size(optim_param.bdx,2) ~= 2)
        errmsg = sprintf('%s\n%s %s','Incorrect use of function dynopt:', ...
            'Parameter BDX must be an nx-by-2 numeric matrix,', ...
            'where nx is number of control variables.');
        error(errmsg);
    end   
end
%..................................................................

