<?xml version="1.0"?> 

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:xhtml="http://www.w3.org/1999/xhtml">
<xsl:output indent="yes" method="xml"/>

<xsl:template match="quiz">
  <quiz>
    <xsl:apply-templates/>
  </quiz>
</xsl:template>

<xsl:template match="subproblem">
</xsl:template>

<xsl:template match="problem">
  <question type="cloze">
    <name><text><xsl:value-of select="@name"/></text></name> 
    <questiontext format="html"><text>  
    <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
      <xsl:for-each select="subproblem">
        <xsl:apply-templates select="problemtext" />
        <xsl:text>&#10;</xsl:text>
      </xsl:for-each> 
    <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
    </text></questiontext>
    <image> <xsl:apply-templates select="img" mode="show"/></image>
    <image_base64> <xsl:apply-templates select="img" mode="show"/></image_base64>
    <penalty>0.1</penalty>
    <shuffleanswers>0</shuffleanswers> 
  </question>
</xsl:template>

<xsl:template match="problemtext">
  <xsl:apply-templates/>
  <xsl:choose> 
    <xsl:when test="../@numerical = 'yes'"> 
      <xsl:apply-templates select="../answers" mode="numerical" />
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:apply-templates select="../answers" mode="show" />
    </xsl:otherwise> 
  </xsl:choose> 

</xsl:template>

<xsl:template match="img" mode="show">
  <img>
    <xsl:attribute name="src">
      <xsl:value-of select="@src"/>
      <xsl:text>.jpg</xsl:text>
    </xsl:attribute>
  </img>
</xsl:template>

<xsl:template match="img">
</xsl:template>

<xsl:template match="span">
  <xsl:if test="@class = 'math'">
    <xsl:text>$$</xsl:text><xsl:value-of select="."/><xsl:text>$$</xsl:text>
  </xsl:if>
  <xsl:if test="@class = 'smath'">
    <xsl:value-of select="."/>
  </xsl:if>
</xsl:template>


<xsl:template match="answers">
</xsl:template>

<xsl:template match="answers" mode="show">
  <br/>
  <xsl:text>&#10;</xsl:text>
  <xsl:for-each select="choice">
    <xsl:sort data-type="number" select="@order"/>
    <xsl:number value="position()" format="A: "/>
    <xsl:apply-templates/>
    <br/>
    <xsl:text>&#10;</xsl:text>
  </xsl:for-each> 
  
  <xsl:text>Vyberte jednu odpoveď: {</xsl:text><xsl:value-of select="../@score"/><xsl:text>:MULTICHOICE:</xsl:text>
  <xsl:for-each select="choice">
    <xsl:sort data-type="number" select="@order"/>
        <xsl:if test="@ans = 'gooditem'">
          <xsl:text>~=</xsl:text><xsl:number value="position()" format="A "/>
          <xsl:text>#Correct Answer!</xsl:text>
        </xsl:if>
        <xsl:if test="@ans = 'baditem'">
          <xsl:text>~</xsl:text><xsl:number value="position()" format="A"/>
          <xsl:text>#Sorry!</xsl:text>
        </xsl:if>
  </xsl:for-each> 
  <xsl:text>}</xsl:text>
  <br/>
  <xsl:text>&#10;</xsl:text>
</xsl:template> 

<xsl:template match="answers" mode="numerical">
  <xsl:text>{</xsl:text><xsl:value-of select="../@score"/><xsl:text>:NUMERICAL:</xsl:text>
  <xsl:for-each select="choice">
    <xsl:sort data-type="number" select="@order"/>
        <xsl:if test="@ans = 'gooditem'">
          <xsl:text>~=</xsl:text>
	  <xsl:apply-templates/>
          <xsl:text>:0.001#Correct Answer!</xsl:text>
        </xsl:if>
  </xsl:for-each> 
  <xsl:text>}</xsl:text>
  <br/>
  <xsl:text>&#10;</xsl:text>

</xsl:template> 


</xsl:stylesheet>
