function source = writetpl(infile, strings)
% WRITETPL - fill template file with concrete values 
  
%  Read from template file INFILE and write to string STR.  STRINGS
%  are defined as 2 column cell array of the form 'NAME', 'VALUE'.
%  Functions searches in INFILE for ##NAME## and replaces it with
%  VALUE. If the strings do not correspond with INFILE warnings are
%  displayed
  
  %read file in
  fhandle=fopen(infile);
  source=fscanf(fhandle,'%c',Inf);
  fclose(fhandle);
  
  n = size(strings,1);
  
  % add strings for permutation of answers
  ii = randperm(5);
  for i=1:5
    strings{n+i,1} = int2str(i); strings{n+i,2} = int2str(ii(i)); 
  end
  
  %replace all strings
  for i=1:n+5
    searchstr = strcat('##',strings{i,1},'##');
    if isempty(findstr(source, searchstr))
      res = sprintf('function writetpl (%s): searchstring %s not found', infile, searchstr);
      disp (res)
    end
    
    source=strrep(source, searchstr, strings{i,2});
  end
  
  %check what has left unchanged = forgotten
  arr = findstr(source, '##');
  if ~(isempty(arr))
    res=sprintf('function writetpl (%s): missing strings: ',infile);
    for i=1:length(arr)/2
      res = sprintf ('%s, %s', res, source(arr(2*i-1):arr(2*i)+1));
    end
    disp(res)
  end
  
