<?xml version="1.0"?> 

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="yes" method="xml"/>

<xsl:template match="quiz">
  <quiz>
    <xsl:apply-templates/>
  </quiz>
</xsl:template>

<xsl:template match="subproblem">
</xsl:template>

<xsl:template match="problem">
  <!-- only the first subproblem due to moodle limitations on -->
  <!-- multi-multi questions -->
  <xsl:for-each select="subproblem">
    <xsl:if test="position()=1">  
      <question type="multichoice">
        <name><text><xsl:value-of select="../@name"/></text></name> 
        <xsl:apply-templates/>
      </question>
    </xsl:if>  
  </xsl:for-each> 
</xsl:template>

<xsl:template match="problemtext">
  <questiontext format="moodle_auto_format"><text><xsl:apply-templates/></text></questiontext>
  <image> <xsl:apply-templates select="img" mode="show"/></image>
  <image_base64> <xsl:apply-templates select="img" mode="show"/></image_base64>
  <penalty>0.1</penalty>
  <hidden>0</hidden>
  <shuffleanswers>1</shuffleanswers> 
  <single>true</single> 
  <defaultgrade><xsl:value-of select="../@score"/></defaultgrade> 
</xsl:template>

<xsl:template match="img" mode="show">
  <img>
    <xsl:attribute name="src">
      <xsl:value-of select="@src"/>
      <xsl:text>.jpg</xsl:text>
    </xsl:attribute>
  </img>
</xsl:template>

<xsl:template match="img">
</xsl:template>

<xsl:template match="span">
  <xsl:if test="@class = 'math'">
    <xsl:text>$$</xsl:text><xsl:value-of select="."/><xsl:text>$$</xsl:text>
  </xsl:if>
  <xsl:if test="@class = 'smath'">
    <xsl:value-of select="."/>
  </xsl:if>
</xsl:template>


<xsl:template match="answers">
  <xsl:for-each select="choice">
    <xsl:sort data-type="number" select="@order"/>
    <answer>
      <xsl:attribute name="fraction">
        <xsl:if test="@ans = 'gooditem'">
          <xsl:text>100</xsl:text>
        </xsl:if>
        <xsl:if test="@ans = 'baditem'">
          <xsl:text>0</xsl:text>
        </xsl:if>
      </xsl:attribute>
      <text><xsl:apply-templates/></text>
      <feedback>
        <xsl:if test="@ans = 'gooditem'">
          <text>Correct Answer!</text></xsl:if>
        <xsl:if test="@ans = 'baditem'">
          <text>Sorry!</text></xsl:if>
      </feedback>
    </answer>
    
  </xsl:for-each> 
</xsl:template> 


</xsl:stylesheet>
