<?xml version="1.0" encoding="windows-1250"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="no" encoding="windows-1250" method="text"/>
<xsl:strip-space elements="problem"/>
<xsl:strip-space elements="subproblem"/>
<xsl:strip-space elements="choice"/>
<xsl:strip-space elements="problemtext"/>

<xsl:template match="quiz">
\documentclass[answers,nosep,scores]{exams1}
\newcount\pdfoutput
\pdfoutput0\relax
\usepackage[top=2cm, bottom=0.5cm,left=1cm,right=2.5cm]{geometry}
\usepackage{slovak}
\usepackage{graphicx}
\usepackage{fancyhdr}
\usepackage{units}

\def\ve#1{\mathchoice{\mbox{\boldmath$\displaystyle#1$}}
{\mbox{\boldmath$\textstyle#1$}}
{\mbox{\boldmath$\scriptstyle#1$}}
{\mbox{\boldmath$\scriptscriptstyle#1$}}}
\renewcommand{\frac}[2]{{\begingroup\displaystyle#1\endgroup\over\displaystyle#2}}

\title{Zklady automatizcie}
\author{M. Bakoov  a M. Fikar}
\target{FCPT STU}
\begin{document}
\newcommand{\datum}{27.8.2006}
\pagestyle{plain}
\renewcommand{\footrulewidth}{0.4pt}
\renewcommand{\headrulewidth}{0.4pt}
\lhead{Meno, S:}
\rhead{}
\lfoot{KIRP FCHPT STU - ZA, \datum }
\cfoot{\thepage}
\begin{exam}[14785934]{\datum}
\rfoot{Test A}
\thispagestyle{fancyplain}

<xsl:for-each select="problem">
\question{}{}{
\begin{problem}[\split]
<xsl:apply-templates/>
\end{problem}
}
</xsl:for-each>
\end{exam}
\end{document}
</xsl:template>

<xsl:template match="subproblem">
<xsl:text>\score{</xsl:text><xsl:value-of select="@score"/>}<xsl:apply-templates/>
</xsl:template>

<xsl:template match="answers">
\begin{choice}
<xsl:for-each select="choice">
  <xsl:sort data-type="number" select="@order"/>
  <xsl:text>\</xsl:text><xsl:value-of select="@ans"/><xsl:text>{</xsl:text><xsl:apply-templates/><xsl:text>}</xsl:text>
</xsl:for-each> 
\end{choice}
</xsl:template>

<xsl:template match="img">
\begin{minipage}{0.39\textwidth}
\includegraphics[width=\textwidth]{<xsl:value-of select="@src"/>} 
\end{minipage}</xsl:template>


<xsl:template match="span"><xsl:text>$</xsl:text><xsl:value-of select="."/><xsl:text>$</xsl:text>
</xsl:template>
</xsl:stylesheet>

