#include <stdio.h>
#include <string.h>

template <class T, int max>
class Stack
{
  T stack[max];
  int pointer;

  public:
  Stack() { pointer=-1; }

  void push(T x);
  T pop();
  T top();
};

template <class T, int max>
void Stack<T,max>::push(T x)
{
  if (pointer<max-1) stack[++pointer]=x;
}

template <class T, int max>
T Stack<T,max>::pop()
{
  if (pointer>=0) return stack[pointer--];
}

template <class T, int max>
T Stack<T,max>::top()
{
  if (pointer>=0) return stack[pointer];
}

void main()
{
  Stack<int,10> S;

  S.push(1);
  S.push(2);
  S.push(3);

  printf("%d\n", S.pop());
  printf("%d\n", S.pop());
  printf("%d\n", S.pop());
}
